<?php
/**
 * Script para verificar un certificado por ID único
 * - Busca en los archivos JSON para encontrar el corredor con el ID proporcionado
 */

// Configuración
header('Content-Type: application/json');

// Verificar si se recibió el ID
$response = [
    'success' => false,
    'message' => 'ID no proporcionado',
    'data' => null
];

if (isset($_GET['id']) && !empty($_GET['id'])) {
    $id = $_GET['id'];
    
    // Distancias disponibles
    $distances = ['5k', '10k', '21k'];

    foreach ($distances as $distance) {
        $filePath = "../data/data_{$distance}.json";
        
        if (file_exists($filePath)) {
            $jsonData = json_decode(file_get_contents($filePath), true);
            
            if ($jsonData) {
                foreach ($jsonData as $runner) {
                    if (isset($runner['UniqueId']) && $runner['UniqueId'] === $id) {
                        // Encontramos el corredor
                        $response['success'] = true;
                        $response['message'] = 'Corredor verificado con éxito';
                        $response['data'] = [
                            'runner' => $runner,
                            'distance' => $distance
                        ];
                        break 2; // Salir de ambos bucles
                    }
                }
            }
        }
    }
    
    if (!$response['success']) {
        $response['message'] = 'No se encontró ningún corredor con el ID proporcionado';
    }
} 

// Enviar respuesta
echo json_encode($response);
?>
