<?php
/**
 * Script para procesar la carga de archivos JSON de resultados
 * - Guarda el archivo nuevo en la carpeta data
 * - Hace una copia del archivo anterior en un directorio de respaldo con la fecha actual
 */

// Configuración
$uploadDir = '../data/';
$backupDir = '../data/backups/';

// Crear directorio de respaldo si no existe
if (!file_exists($backupDir)) {
    mkdir($backupDir, 0755, true);
}

// Respuesta por defecto
$response = [
    'success' => false,
    'message' => 'Ocurrió un error al procesar el archivo.'
];

// Verificar si se recibió el archivo y la distancia
if (isset($_FILES['jsonFile']) && isset($_POST['distance'])) {
    $distance = $_POST['distance'];
    $file = $_FILES['jsonFile'];
    
    // Validar que sea un archivo JSON
    $fileType = pathinfo($file['name'], PATHINFO_EXTENSION);
    if (strtolower($fileType) !== 'json') {
        $response['message'] = 'El archivo debe ser de tipo JSON.';
        echo json_encode($response);
        exit;
    }
    
    // Determinar el nombre de archivo según la distancia
    $targetFilename = '';
    switch ($distance) {
        case '3k':
            $targetFilename = 'data_3k.json';
            break;
        case '5k':
            $targetFilename = 'data_5k.json';
            break;
        case '10k':
            $targetFilename = 'data_10k.json';
            break;
        case '21k':
            $targetFilename = 'data_21k.json';
            break;
        default:
            $response['message'] = 'Distancia no válida.';
            echo json_encode($response);
            exit;
    }
    
    // Ruta completa del archivo destino
    $targetFile = $uploadDir . $targetFilename;
    
    // Si el archivo ya existe, hacer backup con fecha antes de reemplazar
    if (file_exists($targetFile)) {
        $dateStamp = date('Y-m-d_H-i-s');
        $backupFile = $backupDir . pathinfo($targetFilename, PATHINFO_FILENAME) . '_' . $dateStamp . '.json';
        
        if (!copy($targetFile, $backupFile)) {
            $response['message'] = 'No se pudo crear la copia de seguridad del archivo anterior.';
            echo json_encode($response);
            exit;
        }
    }
    
    // Validar que el contenido sea un JSON válido
    $jsonContent = file_get_contents($file['tmp_name']);
    $jsonData = json_decode($jsonContent, true);
    if (!$jsonData) {
        $response['message'] = 'El archivo no contiene un JSON válido.';
        echo json_encode($response);
        exit;
    }
    
    // Agregar IDs únicos a cada corredor
    foreach ($jsonData as &$runner) {
        // Generar un ID único basado en información específica del corredor
        // Incluimos el número de dorsal, nombre del atleta, timestamp y un número aleatorio para garantizar unicidad
        $timestamp = microtime(true);
        $random = rand(1000, 9999);
        $uniqueString = $runner['Athlete'] . $runner['Bib#'] . $timestamp . $random;
        $uniqueId = substr(md5($uniqueString), 0, 8);
        $runner['UniqueId'] = $uniqueId;
    }
    
    // Guardar el JSON modificado con IDs únicos
    file_put_contents($targetFile, json_encode($jsonData));
    
    // Como ya hemos procesado el archivo manualmente, no necesitamos moverlo
    if (true) {
        $response = [
            'success' => true,
            'message' => "El archivo para {$distance} ha sido cargado correctamente. " . 
                        (file_exists($backupFile) ? "Se ha guardado una copia de seguridad del archivo anterior." : "")
        ];
    }
}

// Enviar respuesta como JSON
header('Content-Type: application/json');
echo json_encode($response);
?>
