<?php
// Recibe los datos del frontend
$data = json_decode(file_get_contents('php://input'), true);

$email = $data['email'] ?? '';
$subject = $data['subject'] ?? 'Certificado de participación';
$htmlContent = $data['htmlContent'] ?? '';

if (!$email || !$htmlContent) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Faltan datos requeridos']);
    exit;
}

// Configura tu API Key de Brevo aquí
$apiKey = 'TU_API_KEY_BREVO'; // <-- Coloca aquí tu API Key

// Prepara la solicitud
$payload = [
    'sender' => [
        'name' => 'Nombre del Remitente',
        'email' => 'tucorreo@tudominio.com'
    ],
    'to' => [
        ['email' => $email]
    ],
    'subject' => $subject,
    'htmlContent' => $htmlContent
];

$ch = curl_init('https://api.brevo.com/v3/smtp/email');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'api-key: ' . $apiKey,
    'Content-Type: application/json',
    'accept: application/json'
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode >= 200 && $httpCode < 300) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'error' => $response]);
}
?> 