<?php
/**
 * Script para obtener datos de un corredor por su ID único
 */

// Configuración
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *'); // Para permitir CORS (cross-origin requests)

// Respuesta inicial
$response = [
    'success' => false,
    'message' => 'ID no proporcionado',
    'data' => null
];

// Verificar si se recibió el ID
if (isset($_GET['id']) && !empty($_GET['id'])) {
    $id = $_GET['id'];
    
    // Distancias disponibles
    $distances = ['5k', '10k', '21k'];
    
    foreach ($distances as $distance) {
        $filePath = "../data/data_{$distance}.json";
        
        if (file_exists($filePath)) {
            try {
                $jsonData = json_decode(file_get_contents($filePath), true);
                
                if ($jsonData) {
                    foreach ($jsonData as $runner) {
                        if (isset($runner['UniqueId']) && $runner['UniqueId'] === $id) {
                            // Agregar la distancia a los datos del corredor
                            $runner['Distance'] = $distance;
                            
                            $response = [
                                'success' => true,
                                'message' => 'Datos encontrados',
                                'data' => $runner,
                                'source' => $distance
                            ];
                            
                            echo json_encode($response);
                            exit;
                        }
                    }
                }
            } catch (Exception $e) {
                $response['message'] = 'Error al procesar el archivo: ' . $e->getMessage();
            }
        } else {
            $response['message'] = 'Archivo no encontrado para la distancia: ' . $distance;
        }
    }
    
    // Si llegamos aquí, no se encontró el corredor
    $response['message'] = 'No se encontraron datos para el ID: ' . $id;
}

echo json_encode($response);
