<?php
/**
 * Script para obtener los detalles de un proyecto existente
 */

header('Content-Type: application/json');

$response = [
    'success' => false,
    'message' => '',
    'project' => null
];

try {
    if (!isset($_GET['slug']) || empty($_GET['slug'])) {
        throw new Exception('El slug del proyecto es requerido');
    }
    
    $slug = trim($_GET['slug']);
    
    // Validar formato del slug
    if (!preg_match('/^[a-z0-9-]+$/', $slug)) {
        throw new Exception('Formato de slug inválido');
    }
    
    // Directorio del proyecto
    $baseDir = dirname(__DIR__);
    $projectsDir = dirname($baseDir) . '/crono-projects';
    $projectPath = $projectsDir . '/' . $slug;
    
    // Verificar que el proyecto existe
    if (!file_exists($projectPath)) {
        throw new Exception('El proyecto no existe');
    }
    
    // Leer metadata del proyecto
    $metadataPath = $projectPath . '/project-metadata.json';
    if (!file_exists($metadataPath)) {
        throw new Exception('No se encontró la metadata del proyecto');
    }
    
    $metadata = json_decode(file_get_contents($metadataPath), true);
    if ($metadata === null) {
        throw new Exception('Error al leer la metadata del proyecto');
    }
    
    // Verificar qué archivos de datos existen
    $dataDir = $projectPath . '/data';
    $existingDataFiles = [];
    foreach ($metadata['distances'] as $dist) {
        $dataFile = $dataDir . '/data_' . $dist . '.json';
        if (file_exists($dataFile)) {
            $existingDataFiles[] = $dist;
        }
    }
    
    // Buscar imagen de portada
    $coverImage = null;
    $imagesDir = $projectPath . '/assets/images';
    $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
    
    foreach ($imageExtensions as $ext) {
        $imagePath = $imagesDir . '/cover-image.' . $ext;
        if (file_exists($imagePath)) {
            $coverImage = 'assets/images/cover-image.' . $ext;
            break;
        }
    }
    
    // Leer configuración del config.js
    $configData = null;
    $configPath = $projectPath . '/config.js';
    if (file_exists($configPath)) {
        $configContent = file_get_contents($configPath);
        
        // Extraer baseStartTime
        if (preg_match('/baseStartTime:\s*["\']([^"\']+)["\']/', $configContent, $matches)) {
            $configData['baseStartTime'] = $matches[1];
        }
        
        // Extraer startTimes
        if (preg_match('/startTimes:\s*\{([^}]+)\}/', $configContent, $matches)) {
            $startTimesStr = $matches[1];
            $configData['startTimes'] = [];
            
            // Extraer cada distancia y su tiempo
            preg_match_all('/["\']([^"\']+)["\']\s*:\s*["\']([^"\']+)["\']/', $startTimesStr, $timeMatches, PREG_SET_ORDER);
            foreach ($timeMatches as $match) {
                $configData['startTimes'][$match[1]] = $match[2];
            }
        }
    }
    
    $response['success'] = true;
    $response['project'] = [
        'name' => $metadata['name'],
        'slug' => $metadata['slug'],
        'date' => $metadata['date'] ?? '',
        'distances' => $metadata['distances'],
        'existingDataFiles' => $existingDataFiles,
        'coverImage' => $coverImage,
        'created' => $metadata['created'],
        'path' => $projectPath,
        'config' => $configData
    ];
    
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

echo json_encode($response);
?>
