<?php
/**
 * Script para eliminar un proyecto generado
 */

header('Content-Type: application/json');

$response = [
    'success' => false,
    'message' => ''
];

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['slug']) || empty($input['slug'])) {
        throw new Exception('Slug del proyecto no proporcionado');
    }
    
    $slug = $input['slug'];
    
    // Validar slug
    if (!preg_match('/^[a-z0-9-]+$/', $slug)) {
        throw new Exception('Slug inválido');
    }
    
    $baseDir = dirname(__DIR__);
    $projectsDir = dirname($baseDir) . '/crono-projects';
    $projectPath = $projectsDir . '/' . $slug;
    
    if (!file_exists($projectPath)) {
        throw new Exception('El proyecto no existe');
    }
    
    if (!is_dir($projectPath)) {
        throw new Exception('La ruta no es un directorio válido');
    }
    
    // Eliminar directorio recursivamente
    deleteDirectory($projectPath);
    
    $response['success'] = true;
    $response['message'] = 'Proyecto eliminado exitosamente';
    
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

echo json_encode($response);

/**
 * Eliminar directorio recursivamente
 */
function deleteDirectory($dir) {
    if (!file_exists($dir)) {
        return true;
    }
    
    if (!is_dir($dir)) {
        return unlink($dir);
    }
    
    foreach (scandir($dir) as $item) {
        if ($item == '.' || $item == '..') {
            continue;
        }
        
        if (!deleteDirectory($dir . DIRECTORY_SEPARATOR . $item)) {
            return false;
        }
    }
    
    return rmdir($dir);
}
?>
