<?php
// Configuración de base de datos
class DatabaseConfig {
    const DB_HOST = 'localhost';
    const DB_NAME = 'fhinixco_cronoh_cinepolis2025';
    const DB_USER = 'tu_usuario';
    const DB_PASS = 'tu_password';
    
    // Configuración de Email (Brevo)
    const BREVO_API_KEY = 'TU_API_KEY_BREVO';
    const SENDER_NAME = 'Cronoh';
    const SENDER_EMAIL = 'contacto@cronoh.mx';
    
    // Configuración de envío masivo
    const BATCH_SIZE = 100; // Número de emails por lote
    const MAX_ATTEMPTS = 3; // Máximo número de intentos por email
    const DELAY_BETWEEN_BATCHES = 5; // Segundos entre lotes
    
    // URL base para las estadísticas
    const STATS_BASE_URL = 'https://resultados.cronoh.mx/espn_2025/index.html?id=';
    
    public static function getConnection() {
        try {
            $pdo = new PDO(
                "mysql:host=" . self::DB_HOST . ";dbname=" . self::DB_NAME . ";charset=utf8mb4",
                self::DB_USER,
                self::DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
            return $pdo;
        } catch (PDOException $e) {
            error_log("Error de conexión a la base de datos: " . $e->getMessage());
            throw new Exception("Error de conexión a la base de datos");
        }
    }
}
?>
