<?php
/**
 * Script para cPanel - Envío automático de certificados
 * Este script debe configurarse para ejecutarse cada 5 minutos vía cron job
 * 
    * Requiere el archivo mass_email_sender.php
    */

// Configurar zona horaria
date_default_timezone_set('America/Mexico_City');

// Incluir el archivo principal
require_once dirname(__FILE__) . '/mass_email_sender.php';

try {
    // Crear instancia del enviador
    $sender = new MassEmailSender();
    
    // Log de inicio
    echo "[" . date('Y-m-d H:i:s') . "] === INICIO CRON JOB ===\n";
    
    // Procesar cola de emails
    $sender->processEmailQueue();
    
    // Log de finalización
    echo "[" . date('Y-m-d H:i:s') . "] === FIN CRON JOB ===\n\n";
    
} catch (Exception $e) {
    echo "[" . date('Y-m-d H:i:s') . "] ERROR CRÍTICO: " . $e->getMessage() . "\n";
    
    // Opcional: enviar email de alerta al administrador
    $alertEmail = 'alonsocorderosantiago@gmail.com';
    $subject = 'Error en Cron Job de Envío de Certificados';
    $message = "Se ha producido un error en el cron job de envío de certificados:\n\n";
    $message .= "Fecha: " . date('Y-m-d H:i:s') . "\n";
    $message .= "Error: " . $e->getMessage() . "\n";
    $message .= "Archivo: " . $e->getFile() . "\n";
    $message .= "Línea: " . $e->getLine() . "\n";
    
    @mail($alertEmail, $subject, $message);
    
    exit(1);
}
?>
