// Configuración global de la aplicación
const CONFIG = {
    // Tiempo base general para la primera captura (HH:MM:SS)
    baseStartTime: "1:09:43",  // Hora de la primera foto
    
    // Tiempos de inicio específicos por distancia (HH:MM:SS)
    startTimes: {
        '3K': "1:00:00",    // Una hora después del tiempo base
        '5K': "1:00:00",    // Una hora después del tiempo base
        '10K': "1:00:00",   // Una hora después del tiempo base
        '21K': "1:00:00"    // Una hora después del tiempo base
    },
    
    // Configuración de la aplicación
    appName: 'Crono',
    version: '1.0.0',
    
    // Configuración de la base de datos
    database: {
        host: 'localhost',
        port: 3306,
        name: 'crono_db'
    },
    
    // Configuración de la API
    api: {
        baseUrl: '/api',
        timeout: 5000
    },
    
    // Configuración de la interfaz
    ui: {
        theme: 'light',
        language: 'es'
    }
};

// Exportar la configuración
export default CONFIG; 