// Importar la configuración
import CONFIG from '../../config.js';

// Función para convertir tiempo en formato "HH:MM:SS" a segundos
function timeToSeconds(time) {
    const [hours, minutes, seconds] = time.split(':').map(Number);
    return hours * 3600 + minutes * 60 + seconds;
}

// Función para convertir segundos a formato "HH:MM:SS"
function secondsToTime(seconds) {
    const hours = Math.floor(seconds / 3600);
    const minutes = Math.floor((seconds % 3600) / 60);
    const secs = seconds % 60;
    return `${hours}:${String(minutes).padStart(2, '0')}:${String(secs).padStart(2, '0')}`;
}

// Función para obtener el número de imagen basado en el tiempo
function getPhotoNumber(officialTime, distanceStartTime, baseStartTime) {
    // console.log('=== Calculando número de foto ===');
    // console.log('Tiempo oficial:', officialTime);
    // console.log('Tiempo inicio distancia:', distanceStartTime);
    // console.log('Tiempo base:', baseStartTime);
    
    // Convertir todos los tiempos a segundos desde 00:00:00
    const officialSeconds = timeToSeconds(officialTime);
    const startTimeSeconds = timeToSeconds(distanceStartTime);
    const baseTimeSeconds = timeToSeconds(baseStartTime);
    
    // console.log('Segundos oficiales:', officialSeconds);
    // console.log('Segundos inicio:', startTimeSeconds);
    // console.log('Segundos base:', baseTimeSeconds);
    
    // Calcular el tiempo absoluto sumando el tiempo oficial al tiempo de inicio de la categoría
    const realTimeSeconds = startTimeSeconds + officialSeconds;
    // console.log('Tiempo real en segundos:', realTimeSeconds);
    
    // Calcular los segundos desde el momento base (inicio de las fotos)
    const elapsedSeconds = realTimeSeconds - baseTimeSeconds;
    // console.log('Segundos transcurridos desde el inicio de las fotos:', elapsedSeconds);
    
    // Aseguramos que el número sea positivo
    const photoNumber = Math.abs(elapsedSeconds) + 1;
    // console.log('Número de foto calculado:', photoNumber);
    return photoNumber;
}

// Función para generar un rango de tiempos alrededor de un tiempo oficial
function generateTimeRange(officialTime, startTime, range = 5) {
    const officialSeconds = timeToSeconds(officialTime);
    const times = [];
    
    for (let offset = -range; offset <= range; offset++) {
        // Si ya tenemos 10 fotos, salimos del bucle
        if (times.length >= 10) break;
        
        const time = secondsToTime(officialSeconds + offset);
        const number = getPhotoNumber(time, startTime, CONFIG.baseStartTime);
        times.push({ time, number });
    }
    
    return times;
}

// Función para asignar las fotos en el modal
export function assignPhotosToModal(officialTime, runner) {
    // Validar que el runner tenga la propiedad distance definida
    if (!runner || !runner.distance) {
        console.error('Error: runner.distance no está definido:', runner);
        return;
    }
    
    const distance = runner.distance.toUpperCase(); // Convertir a mayúsculas para coincidir con la configuración
    const baseStartTime = CONFIG.baseStartTime;
    const distanceStartTime = CONFIG.startTimes[distance] || CONFIG.startTimes['42K']; // Usar 42K como valor por defecto
    
    // console.log('=== Información de Tiempos ===');
    // console.log('Distancia:', distance);
    // console.log('Tiempo base:', baseStartTime);
    // console.log('Tiempo inicio distancia:', distanceStartTime);
    // console.log('Tiempo oficial:', officialTime);
    
    const grid = document.getElementById('photos-modal-grid');
    if (!grid) return;

    grid.innerHTML = '';
    
    // Generar fotos en un rango de tiempo alrededor del tiempo oficial (exactamente 10 fotos)
    const photos = generateTimeRange(officialTime, distanceStartTime, 5);

    // Array para almacenar las fotos para la galería
    const galleryPhotos = photos.map(photo => ({
        src: `pictures/IMG_ (${photo.number}).jpg`,
        time: photo.time
    }));

    photos.forEach((photo, index) => {
        const div = document.createElement('div');
        div.className = 'photo-item';
        
        const img = document.createElement('img');
        img.src = `pictures/IMG_ (${photo.number}).jpg`;
        img.alt = `Foto del corredor - ${photo.time}`;
        
        const timeLabel = document.createElement('div');
        timeLabel.className = 'photo-time';
        timeLabel.textContent = photo.time;
        
        // Añadir evento click para abrir la galería
        div.addEventListener('click', () => {
            initGallery(galleryPhotos);
            currentPhotoIndex = index;
            updateGalleryView();
            document.getElementById('gallery-modal').style.display = 'block';
            document.body.style.overflow = 'hidden';
        });
        
        div.appendChild(img);
        div.appendChild(timeLabel);
        grid.appendChild(div);
    });
} 