// Script para manejar la apertura automática de modal desde email
// Este archivo debe ser incluido en index.html después de results.js

document.addEventListener('DOMContentLoaded', function() {
    // Función para abrir el modal automáticamente desde el email
    function handleAutoOpenModal() {
        const urlParams = new URLSearchParams(window.location.search);
        const openModalParam = urlParams.get('openModal');
        
        if (openModalParam) {
            // Cargar todas las distancias para poder encontrar cualquier corredor
            console.log('Parámetro openModal detectado, cargando todas las distancias...');
            window.reloadResultsData(); // Cargar todas las distancias
            
            // Esperar a que los datos estén cargados
            document.addEventListener('resultsDataLoaded', function() {
                // Buscar el corredor por UniqueId
                const runner = resultsData.find(r => r.UniqueId === openModalParam);
                
                if (runner) {
                    // Simular el click en el modal usando el número de bib
                    setTimeout(() => {
                        const bibNumber = runner.bib;
                        
                        // Rellenar los datos del corredor en el modal (copiado de results.js)
                        document.getElementById('modal-runner-name').textContent = runner.name;
                        document.getElementById('modal-runner-category').textContent = `${runner.distance} - ${runner.gender === 'M' ? 'Varonil' : 'Femenil'} - ${runner.category}`;
                        document.getElementById('modal-distance').textContent = runner.distance;
                        document.getElementById('modal-gender').textContent = runner.gender;
                        document.getElementById('modal-category').textContent = runner.category;
                        document.getElementById('modal-position').textContent = runner.position;
                        
                        // Mostrar ID único de verificación
                        const uniqueIdElement = document.getElementById('modal-unique-id');
                        if (uniqueIdElement) {
                            uniqueIdElement.textContent = runner.UniqueId || '----';
                        }
                        
                        // Calcular el total real de corredores para esta distancia
                        const runnersForDistance = resultsData.filter(r => r.distance === runner.distance);
                        const totalRunners = runnersForDistance.length;
                        
                        document.getElementById('modal-total-runners').textContent = `${totalRunners} corredores`;
                        document.getElementById('modal-runners-before').textContent = runner.position - 1;
                        document.getElementById('modal-runners-after').textContent = totalRunners - runner.position;
                        
                        // Configurar parciales
                        const distanceConfig = {
                            '3K': { parciales: [1.5, 3], etiquetas: ['1.5K', '3K'] },
                            '5K': { parciales: [2.5, 5], etiquetas: ['2.5K', '5K'] },
                            '10K': { parciales: [2.5, 5, 7.5, 10], etiquetas: ['2.5K', '5K', '7.5K', '10K'] }
                        };
                        
                        const config = distanceConfig[runner.distance] || { parciales: [], etiquetas: [] };
                        
                        // Actualizar las etiquetas de los parciales en el modal
                        const parcialesGrid = document.getElementById('modal-parcials-grid');
                        if (parcialesGrid) {
                            const headers = parcialesGrid.querySelectorAll('.parcial-header');
                            headers.forEach((header, index) => {
                                if (config.etiquetas[index]) {
                                    header.textContent = config.etiquetas[index];
                                    header.style.display = 'block';
                                } else {
                                    header.style.display = 'none';
                                }
                            });
                            
                            const tiempos = parcialesGrid.querySelectorAll('.parcial-tiempo');
                            const ritmos = parcialesGrid.querySelectorAll('.parcial-ritmo');
                            
                            tiempos.forEach((tiempo, index) => {
                                const parcialKey = `mp${index + 1}`;
                                if (runner[parcialKey] && config.etiquetas[index]) {
                                    tiempo.textContent = runner[parcialKey].time || "00:00:00";
                                    tiempo.parentElement.style.display = 'block';
                                } else {
                                    tiempo.parentElement.style.display = 'none';
                                }
                            });
                            
                            ritmos.forEach((ritmo, index) => {
                                const parcialKey = `mp${index + 1}`;
                                if (runner[parcialKey] && config.etiquetas[index]) {
                                    ritmo.textContent = runner[parcialKey].pace || "0.00 km/h";
                                    ritmo.parentElement.style.display = 'block';
                                } else {
                                    ritmo.parentElement.style.display = 'none';
                                }
                            });
                        }
                        
                        // Calcular min/km
                        function calculateMinKm(time, pace) {
                            if (!time || !pace || time === "00:00:00" || pace === "0.00 km/h") return "00:00";
                            const paceNum = parseFloat(pace);
                            if (paceNum === 0) return "00:00";
                            const minKm = 60 / paceNum;
                            const minutes = Math.floor(minKm);
                            const seconds = Math.round((minKm - minutes) * 60);
                            return `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
                        }
                        
                        // Actualizar tiempos finales
                        document.getElementById('modal-finish-time').textContent = runner.finishTime?.time || "00:00:00";
                        document.getElementById('modal-finish-pace').textContent = runner.finishTime?.pace || "0.00 km/h";
                        document.getElementById('modal-gun-time').textContent = runner.gunTime?.time || "00:00:00";
                        document.getElementById('modal-gun-pace').textContent = runner.gunTime?.pace || "0.00 km/h";
                        
                        document.getElementById('modal-finish-minkm').textContent = calculateMinKm(runner.finishTime?.time, runner.finishTime?.pace);
                        document.getElementById('modal-gun-minkm').textContent = calculateMinKm(runner.gunTime?.time, runner.gunTime?.pace);
                        
                        // Generar gráfica (copiado de results.js)
                        setTimeout(() => {
                            const ctx = document.getElementById('performanceChart').getContext('2d');
                            if (window.performanceChartInstance) {
                                window.performanceChartInstance.destroy();
                            }
                            
                            function timeToMinutes(t) {
                                if (!t) return 0;
                                const parts = t.split(':').map(Number);
                                if (parts.length === 3) return parts[0]*60 + parts[1] + parts[2]/60;
                                if (parts.length === 2) return parts[0]*60 + parts[1];
                                return Number(t);
                            }
                            
                            let labels = [];
                            let runnerData = [];
                            let primerLugarData = [];
                            
                            for (let i = 1; i <= 5; i++) {
                                const parcialKey = `mp${i}`;
                                if (runner[parcialKey] && runner[parcialKey].time && runner[parcialKey].time !== "00:00:00") {
                                    labels.push(`Parcial ${i}`);
                                    runnerData.push(timeToMinutes(runner[parcialKey].time));
                                }
                            }
                            
                            // Agregar tiempo final
                            if (runner.finishTime && runner.finishTime.time && runner.finishTime.time !== "00:00:00") {
                                labels.push('Final');
                                runnerData.push(timeToMinutes(runner.finishTime.time));
                            }
                            
                            // Buscar el primer lugar para comparación
                            const primerLugar = resultsData.find(r => r.distance === runner.distance && r.position === 1);
                            if (primerLugar) {
                                for (let i = 1; i <= 5; i++) {
                                    const parcialKey = `mp${i}`;
                                    if (primerLugar[parcialKey] && primerLugar[parcialKey].time && primerLugar[parcialKey].time !== "00:00:00") {
                                        primerLugarData.push(timeToMinutes(primerLugar[parcialKey].time));
                                    }
                                }
                                if (primerLugar.finishTime && primerLugar.finishTime.time && primerLugar.finishTime.time !== "00:00:00") {
                                    primerLugarData.push(timeToMinutes(primerLugar.finishTime.time));
                                }
                            }
                            
                            window.performanceChartInstance = new Chart(ctx, {
                                type: 'line',
                                data: {
                                    labels: labels,
                                    datasets: [
                                        {
                                            label: runner.name,
                                            data: runnerData,
                                            borderColor: '#e63946',
                                            backgroundColor: 'rgba(230, 57, 70, 0.1)',
                                            tension: 0.1
                                        },
                                        {
                                            label: '1er Lugar',
                                            data: primerLugarData,
                                            borderColor: '#457b9d',
                                            backgroundColor: 'rgba(69, 123, 157, 0.1)',
                                            tension: 0.1
                                        }
                                    ]
                                },
                                options: {
                                    responsive: true,
                                    plugins: {
                                        legend: { display: true },
                                        title: { display: true, text: 'Gráfica de desempeño (minutos)' }
                                    },
                                    scales: {
                                        y: {
                                            title: { display: true, text: 'Minutos' },
                                            beginAtZero: true
                                        }
                                    }
                                }
                            });
                        }, 100);
                        
                        // Mostrar el modal
                        const modal = document.getElementById('runner-details-modal');
                        if (modal) {
                            modal.style.display = 'block';
                            document.body.style.overflow = 'hidden';
                            
                            // Hacer scroll hacia arriba
                            window.scrollTo(0, 0);
                        }
                        
                    }, 500); // Pequeño delay para asegurar que todo esté cargado
                } else {
                    console.warn('No se encontró el corredor con ID:', openModalParam);
                    // Mostrar un mensaje de error al usuario
                    setTimeout(() => {
                        alert(`No se encontró el corredor con el ID proporcionado: ${openModalParam}. Por favor, verifica el enlace.`);
                    }, 1000);
                }
            });
        }
    }
    
    // Ejecutar la función
    handleAutoOpenModal();
});
