// Importar la configuración
import CONFIG from '../../config.js';

// Offset para ajustar la numeración real de las imágenes
const PHOTO_OFFSET = 0; // Cambia este valor al número real de la primera imagen menos 1 (por ejemplo, si la primera es 1000, pon 999)

// Función para convertir tiempo en formato "HH:MM:SS" a segundos
function timeToSeconds(time) {
    const [hours, minutes, seconds] = time.split(':').map(Number);
    return hours * 3600 + minutes * 60 + seconds;
}

// Función para convertir segundos a formato "HH:MM:SS"
function secondsToTime(seconds) {
    const hours = Math.floor(seconds / 3600);
    const minutes = Math.floor((seconds % 3600) / 60);
    const secs = seconds % 60;
    return `${hours}:${String(minutes).padStart(2, '0')}:${String(secs).padStart(2, '0')}`;
}

// Función para obtener el número de imagen basado en el tiempo
function getPhotoNumber(officialTime, distanceStartTime, baseStartTime) {
    console.log('=== Calculando número de foto ===');
    console.log('Tiempo oficial:', officialTime);
    console.log('Tiempo inicio distancia:', distanceStartTime);
    console.log('Tiempo base:', baseStartTime);
    
    // Convertir todos los tiempos a segundos desde 00:00:00
    const officialSeconds = timeToSeconds(officialTime);
    const startTimeSeconds = timeToSeconds(distanceStartTime);
    const baseTimeSeconds = timeToSeconds(baseStartTime);
    
    console.log('Segundos oficiales:', officialSeconds);
    console.log('Segundos inicio:', startTimeSeconds);
    console.log('Segundos base:', baseTimeSeconds);
    
    // Si la carrera inicia a la misma hora que el tiempo base
    if (distanceStartTime === baseStartTime) {
        console.log('Es carrera con horario igual al tiempo base');
        // Para esta distancia, el tiempo transcurrido es directo
        const elapsedSeconds = officialSeconds - startTimeSeconds;
        console.log('Segundos transcurridos:', elapsedSeconds);
        const photoNumber = elapsedSeconds + 1;
        console.log('Número de foto calculado:', photoNumber);
        return photoNumber;
    } else {
        console.log('Es otra distancia (3K, 5K, 10K)');
        
        // Convertir el tiempo oficial a la primera hora
        // Si el tiempo está en la segunda hora (2:XX:XX), convertirlo a (1:XX:XX)
        const adjustedOfficialSeconds = officialSeconds >= 7200 ? officialSeconds - 3600 : officialSeconds;
        
        // Calcular el tiempo transcurrido desde el inicio de las fotos (1:09:43)
        const elapsedSeconds = adjustedOfficialSeconds - baseTimeSeconds;
        console.log('Segundos transcurridos:', elapsedSeconds);
        
        const photoNumber = Math.abs(elapsedSeconds) + 1;
        console.log('Número de foto calculado:', photoNumber);
        return photoNumber;
    }
}

// Función para obtener los tiempos y números de fotos basados en el tiempo oficial
function getPhotoTimes(officialTime, startTime) {
    const officialSeconds = timeToSeconds(officialTime);
    
    return {
        photo1: {
            time: secondsToTime(officialSeconds - 2),
            number: getPhotoNumber(secondsToTime(officialSeconds - 2), startTime, CONFIG.baseStartTime)
        },
        photo2: {
            time: secondsToTime(officialSeconds - 1),
            number: getPhotoNumber(secondsToTime(officialSeconds - 1), startTime, CONFIG.baseStartTime)
        },
        photo3: {
            time: officialTime,
            number: getPhotoNumber(officialTime, startTime, CONFIG.baseStartTime)
        },
        photo4: {
            time: secondsToTime(officialSeconds + 1),
            number: getPhotoNumber(secondsToTime(officialSeconds + 1), startTime, CONFIG.baseStartTime)
        },
        photo5: {
            time: secondsToTime(officialSeconds + 2),
            number: getPhotoNumber(secondsToTime(officialSeconds + 2), startTime, CONFIG.baseStartTime)
        }
    };
}

// Función para asignar las fotos en el modal
export function assignPhotosToModal(officialTime, runner) {
    const distance = runner.distance.toUpperCase(); // Convertir a mayúsculas para coincidir con la configuración
    const baseStartTime = CONFIG.baseStartTime;
    const distanceStartTime = CONFIG.startTimes[distance] || CONFIG.startTimes['42K']; // Usar 42K como valor por defecto
    
    console.log('=== Información de Tiempos ===');
    console.log('Distancia:', distance);
    console.log('Tiempo base:', baseStartTime);
    console.log('Tiempo inicio distancia:', distanceStartTime);
    console.log('Tiempo oficial:', officialTime);
    
    // Calcular el tiempo relativo desde el inicio de la distancia
    const photoTimes = getPhotoTimes(officialTime, distanceStartTime);
    
    console.log('=== Tiempos de las Fotos ===');
    console.log('Foto 1 (2s antes):', photoTimes.photo1.time, '- Número:', photoTimes.photo1.number);
    console.log('Foto 2 (1s antes):', photoTimes.photo2.time, '- Número:', photoTimes.photo2.number);
    console.log('Foto 3 (tiempo oficial):', photoTimes.photo3.time, '- Número:', photoTimes.photo3.number);
    console.log('Foto 4 (1s después):', photoTimes.photo4.time, '- Número:', photoTimes.photo4.number);
    console.log('Foto 5 (2s después):', photoTimes.photo5.time, '- Número:', photoTimes.photo5.number);
    console.log('===========================');

    const grid = document.getElementById('photos-modal-grid');
    if (!grid) return;

    grid.innerHTML = '';
    
    // Crear elementos para cada foto en orden cronológico
    const officialSeconds = timeToSeconds(officialTime);
    const photos = [];
    for (let offset = -5; offset < 5; offset++) {
        const time = secondsToTime(officialSeconds + offset);
        const number = getPhotoNumber(time, distanceStartTime, baseStartTime);
        photos.push({ time, number });
    }

    // Array para almacenar las fotos para la galería
    const galleryPhotos = photos.map(photo => ({
        src: `pictures/IMG_ (${photo.number}).jpg`,
        time: photo.time
    }));

    photos.forEach((photo, index) => {
        const div = document.createElement('div');
        div.className = 'photo-item';
        
        const img = document.createElement('img');
        img.src = `pictures/IMG_ (${photo.number}).jpg`;
        img.alt = `Foto del corredor - ${photo.time}`;
        
        const timeLabel = document.createElement('div');
        timeLabel.className = 'photo-time';
        timeLabel.textContent = photo.time;
        
        // Añadir evento click para abrir la galería
        div.addEventListener('click', () => {
            initGallery(galleryPhotos);
            currentPhotoIndex = index;
            updateGalleryView();
            document.getElementById('gallery-modal').style.display = 'block';
            document.body.style.overflow = 'hidden';
        });
        
        div.appendChild(img);
        div.appendChild(timeLabel);
        grid.appendChild(div);
    });
} 