// Función para descargar certificado usando HTML2Canvas
function downloadCertificate() {
    console.log('Función downloadCertificate ejecutada');
    // Referencia al elemento que contiene el certificado
    const certificate = document.querySelector('.runner-certificate');
    console.log('Elemento certificado encontrado:', certificate);
    
    // Mostrar mensaje de carga
    const loadingMessage = document.createElement('div');
    loadingMessage.style.position = 'fixed';
    loadingMessage.style.top = '50%';
    loadingMessage.style.left = '50%';
    loadingMessage.style.transform = 'translate(-50%, -50%)';
    loadingMessage.style.background = 'rgba(0,0,0,0.7)';
    loadingMessage.style.color = 'white';
    loadingMessage.style.padding = '20px 30px';
    loadingMessage.style.borderRadius = '10px';
    loadingMessage.style.zIndex = '9999';
    loadingMessage.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Generando certificado...';
    document.body.appendChild(loadingMessage);
    
    // Usar HTML2Canvas para convertir el certificado a una imagen
    html2canvas(certificate, {
        scale: 2, // Mayor calidad
        useCORS: true,
        allowTaint: true,
        backgroundColor: null
    }).then(canvas => {
        // Convertir el canvas a una URL de imagen
        const imgData = canvas.toDataURL('image/jpeg', 1.0);
        
        // Crear un enlace para descargar la imagen
        const link = document.createElement('a');
        link.href = imgData;
        
        // Obtener el nombre del corredor para el nombre del archivo
        const runnerName = document.getElementById('runner-name').textContent.trim();
        const fileName = `certificado_${runnerName.replace(/\s+/g, '_')}.jpg`;
        
        link.download = fileName;
        link.click();
        
        // Eliminar el mensaje de carga
        document.body.removeChild(loadingMessage);
        
        // Mostrar mensaje de éxito
        const successMessage = document.createElement('div');
        successMessage.style.position = 'fixed';
        successMessage.style.top = '50%';
        successMessage.style.left = '50%';
        successMessage.style.transform = 'translate(-50%, -50%)';
        successMessage.style.background = 'rgba(42, 157, 143, 0.9)';
        successMessage.style.color = 'white';
        successMessage.style.padding = '20px 30px';
        successMessage.style.borderRadius = '10px';
        successMessage.style.zIndex = '9999';
        successMessage.innerHTML = '<i class="fas fa-check-circle"></i> Certificado descargado correctamente!';
        
        document.body.appendChild(successMessage);
        
        // Eliminar el mensaje de éxito después de 3 segundos
        setTimeout(() => {
            document.body.removeChild(successMessage);
        }, 3000);
    }).catch(error => {
        console.error('Error al generar el certificado:', error);
        
        // Eliminar el mensaje de carga
        document.body.removeChild(loadingMessage);
        
        // Mostrar mensaje de error
        const errorMessage = document.createElement('div');
        errorMessage.style.position = 'fixed';
        errorMessage.style.top = '50%';
        errorMessage.style.left = '50%';
        errorMessage.style.transform = 'translate(-50%, -50%)';
        errorMessage.style.background = 'rgba(230, 57, 70, 0.9)';
        errorMessage.style.color = 'white';
        errorMessage.style.padding = '20px 30px';
        errorMessage.style.borderRadius = '10px';
        errorMessage.style.zIndex = '9999';
        errorMessage.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error al generar el certificado';
        
        document.body.appendChild(errorMessage);
        
        // Eliminar el mensaje de error después de 3 segundos
        setTimeout(() => {
            document.body.removeChild(errorMessage);
        }, 3000);
    });
}

// Función para compartir en redes sociales
function shareOnSocialMedia(network) {
    // Obtener información del corredor
    const runnerName = document.getElementById('runner-name').textContent.trim();
    const runnerPosition = document.getElementById('runner-position').textContent.trim();
    const runnerTime = document.getElementById('runner-time').textContent.trim();
    const runnerDistance = document.getElementById('runner-distance').textContent.trim();
    
    // Crear mensaje para compartir
    const shareMessage = `¡He completado la carrera Lululemon ${runnerDistance} Ciudad de México 2025! Posición: ${runnerPosition} - Tiempo: ${runnerTime}`;
    const encodedMessage = encodeURIComponent(shareMessage);
    const encodedUrl = encodeURIComponent(window.location.href);
    
    // URL para compartir según la red social
    let shareUrl = '';
    
    switch(network) {
        case 'facebook':
            shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodedUrl}&quote=${encodedMessage}`;
            break;
        case 'twitter':
            shareUrl = `https://twitter.com/intent/tweet?text=${encodedMessage}&url=${encodedUrl}`;
            break;
        case 'whatsapp':
            shareUrl = `https://api.whatsapp.com/send?text=${encodedMessage} ${encodedUrl}`;
            break;
        case 'instagram':
            // Instagram no permite compartir directamente a través de URL
            alert('Para compartir en Instagram:\n1. Descarga el certificado\n2. Abre Instagram\n3. Crea una nueva publicación con la imagen del certificado');
            return;
    }
    
    // Abrir ventana para compartir
    window.open(shareUrl, '_blank', 'width=600,height=400');
}