# Crono - Sistema de Cronometraje y Resultados para Carreras

## Descripción
Crono es una aplicación web diseñada para la gestión, visualización y distribución de resultados de eventos deportivos, especialmente carreras atléticas. El sistema permite consultar resultados de carreras, generar certificados de participación personalizados, visualizar fotografías de los participantes y compartir los logros en redes sociales.

## Características Principales

- **Búsqueda y Filtrado de Resultados:** Consulta de resultados por nombre del corredor, número de dorsal, categoría, distancia y género.
- **Visualización Detallada:** Información detallada sobre el rendimiento de cada corredor incluyendo tiempos parciales, tiempos oficiales, ritmo y posición.
- **Certificados Personalizados:** Generación de certificados de participación personalizados para cada corredor.
- **Galería de Imágenes:** Visualización de fotografías de los participantes durante el evento.
- **Compartir en Redes:** Funcionalidad para compartir certificados y resultados en redes sociales.
- **Envío por Correo:** Posibilidad de enviar certificados por correo electrónico.

## Estructura del Proyecto

```
Crono/
├── assets/
│   ├── css/         # Hojas de estilo
│   ├── images/      # Imágenes y recursos gráficos
│   └── js/          # Scripts de JavaScript
├── certificates_data/  # Datos para la generación de certificados
├── data/            # Archivos JSON con datos de resultados
├── php/            # Scripts PHP para backend
├── pictures/       # Fotografías del evento
├── qr_codes/       # Códigos QR para verificación de certificados
├── index.html      # Página principal de resultados
├── certificado.html # Página de certificado de participación
└── config.js       # Configuración global de la aplicación
```

## Tecnologías Utilizadas

- **Frontend:** HTML5, CSS3, JavaScript
- **Gráficos:** Chart.js
- **Manipulación de Imágenes:** html2canvas
- **Iconos:** Font Awesome
- **Backend:** PHP (para envío de correos)
- **API de Correos:** Brevo (antes Sendinblue)

## Configuración

La configuración principal se encuentra en el archivo `config.js`. Algunas de las configuraciones que se pueden ajustar:

- `startTime`: Hora de inicio para sincronización de fotografías
- `appName`: Nombre de la aplicación
- `version`: Versión del sistema
- `database`: Configuración de la base de datos
- `api`: Configuración de la API
- `ui`: Configuración de la interfaz

## Funcionalidades Detalladas

### Búsqueda de Resultados
La página principal (`index.html`) permite a los usuarios buscar resultados utilizando diferentes criterios como nombre, número de dorsal, categoría y distancia.

### Visualización de Rendimiento
Para cada corredor, el sistema muestra información detallada sobre su rendimiento, incluyendo:
- Posición general y por categoría
- Tiempos parciales
- Tiempo chip y tiempo oficial
- Ritmo promedio (min/km y km/h)
- Gráfico de rendimiento

### Certificados
El sistema genera certificados de participación personalizados (`certificado.html`) que incluyen:
- Datos personales del corredor
- Categoría y distancia
- Posición lograda
- Tiempos oficiales
- Código QR para verificación
- Opciones para descargar o compartir el certificado

### Fotografías
El sistema permite visualizar las fotografías tomadas durante el evento, con la posibilidad de:
- Ver una galería completa de imágenes
- Filtrar fotografías por corredor
- Visualizar la hora de captura
- Compartir o descargar fotografías

## Instalación

1. Clone el repositorio en su servidor web:
   ```
   git clone [URL_DEL_REPOSITORIO]
   ```

2. Configure el archivo `config.js` con sus parámetros específicos

3. Para la funcionalidad de envío de correos, actualice el archivo `php/send-certificate.php` con su API key de Brevo:
   ```php
   $apiKey = 'SU_API_KEY_BREVO';
   ```

## Uso

1. Acceda a la página principal `index.html` para consultar resultados
2. Utilice los filtros para encontrar corredores específicos
3. Haga clic en un corredor para ver detalles completos
4. Genere certificados desde la vista detallada del corredor
5. Visualice o descargue fotografías desde la galería

## Licencia

Todos los derechos reservados © 2025 Cronoh

## Contacto

Para más información, contacte a:
- Email: info@cronoh.mx
- Ubicación: Ciudad de México, México