# Crono-Time - Generador de Proyectos de Resultados de Carreras

Sistema automatizado para generar sitios web independientes de resultados de carreras con múltiples distancias.

## Características

- ✅ **Generador de Proyectos**: Crea proyectos independientes con configuración personalizada
- ✅ **Múltiples Distancias**: Soporte para 3K, 5K, 10K, 15K, 21K, 25K, 42K, 50K
- ✅ **Procesamiento Automático de Datos**: Normalización de JSON, generación de UniqueId
- ✅ **Detección Dinámica de Parciales**: Detecta automáticamente parciales en cualquier formato
- ✅ **Certificados Digitales**: Sistema de certificados con QR único
- ✅ **Búsqueda y Filtros**: Por nombre, dorsal, categoría, género, distancia
- ✅ **Responsive**: Diseño adaptable para móvil y escritorio

## Uso del Generador

### 1. Acceder al Generador
Abrir `generator.html` en el navegador

### 2. Configurar el Proyecto
- **Nombre de la carrera**: Ej. "10K Tour CDMX 2025"
- **Fecha del evento**: Seleccionar fecha
- **Slug URL**: Se genera automáticamente (ej. "10k-tour-cdmx-2025")
- **Imagen de portada**: Subir imagen JPG/PNG

### 3. Seleccionar Distancias y Subir JSON
Marcar las distancias que tendrá la carrera y subir el archivo JSON para cada una

### 4. Formato del JSON
El sistema acepta múltiples formatos y los normaliza automáticamente:

```json
[
  {
    "Pos": 1,
    "Athlete": "JUAN PÉREZ",
    "Bib": 2254,
    "Category": "LIBRE VARONIL - de 30 a 39 años",
    "Race": "21K",
    "Gender": "M",
    "5.0 km": "00:19:04",
    "15.0 km": "00:52:57",
    "FinishTime": "01:12:58",
    "GunTime": "01:13:43"
  }
]
```

**Campos aceptados** (se normalizan automáticamente):
- `Bib` / `Bib#` / `bib` → Número de dorsal
- `Athlete` / `Name` / `name` → Nombre del corredor
- `Category` / `category` / `Class` → Categoría
- `Race` / `distance` → Distancia
- `Gender` / `gender` → Género (M/F)
- `FinishTime` / `Chip Time` → Tiempo chip
- `GunTime` / `Gun Time` → Tiempo oficial
- Parciales: `"5.0 km"`, `"15.0 km"`, `"MP1"`, etc.

## Normalización Automática

### Proceso de Generación
Al hacer clic en "Generar Proyecto":
1. Crea directorio en `/crono-projects/{slug}/`
2. Copia y personaliza todos los archivos
3. Procesa y normaliza los JSON:
   - Genera `UniqueId` de 9 caracteres para cada corredor
   - Normaliza nombres de campos
   - Convierte formatos de tiempo a HH:MM:SS
   - Ordena parciales por distancia
4. Configura selectores de distancia
5. Actualiza títulos y referencias

### Campos de Tiempo
- `0:32:06` → `00:32:06` (padding de horas)
- `32:06` → `00:32:06` (agrega hora 00)

### UniqueId
- Hash MD5 de 9 caracteres
- Basado en: Athlete + Bib + Race + Category + timestamp
- Necesario para certificados y fotos

## Tecnologías

- **Frontend**: HTML5, CSS3, JavaScript (Vanilla)
- **Backend**: PHP 7.4+
- **Formatos**: JSON para datos
- **Imágenes**: JPG, PNG, GIF, WEBP

## Desarrollo

Para modificar la plantilla base:
1. Editar archivos en `/assets/`
2. Los cambios se aplicarán a nuevos proyectos generados
3. Proyectos existentes NO se actualizan automáticamente
